# [YooKassa API SDK](../home.md)

# Class: \YooKassa\Request\SelfEmployed\SelfEmployedResponse
### Namespace: [\YooKassa\Request\SelfEmployed](../namespaces/yookassa-request-selfemployed.md)
---
**Summary:**

Класс, представляющий модель SelfEmployed.

**Description:**

Информация о персональных данных

---
### Constants
* No constants found

---
### Properties
| Visibility | Name | Flag | Summary |
| ----------:| ---- | ---- | ------- |
| public | [$confirmation](../classes/YooKassa-Model-SelfEmployed-SelfEmployed.md#property_confirmation) |  | Сценарий подтверждения пользователем заявки ЮMoney на получение прав для регистрации чеков в сервисе Мой налог. |
| public | [$created_at](../classes/YooKassa-Model-SelfEmployed-SelfEmployed.md#property_created_at) |  | Время создания объекта самозанятого. |
| public | [$createdAt](../classes/YooKassa-Model-SelfEmployed-SelfEmployed.md#property_createdAt) |  | Время создания объекта самозанятого. |
| public | [$id](../classes/YooKassa-Model-SelfEmployed-SelfEmployed.md#property_id) |  | Идентификатор самозанятого в ЮKassa. |
| public | [$itn](../classes/YooKassa-Model-SelfEmployed-SelfEmployed.md#property_itn) |  | ИНН самозанятого. |
| public | [$phone](../classes/YooKassa-Model-SelfEmployed-SelfEmployed.md#property_phone) |  | Телефон самозанятого, который привязан к личному кабинету в сервисе Мой налог. |
| public | [$status](../classes/YooKassa-Model-SelfEmployed-SelfEmployed.md#property_status) |  | Статус подключения самозанятого и выдачи ЮMoney прав на регистрацию чеков. |
| public | [$test](../classes/YooKassa-Model-SelfEmployed-SelfEmployed.md#property_test) |  | Признак тестовой операции. |

---
### Methods
| Visibility | Name | Flag | Summary |
| ----------:| ---- | ---- | ------- |
| public | [__construct()](../classes/YooKassa-Common-AbstractObject.md#method___construct) |  | AbstractObject constructor. |
| public | [__get()](../classes/YooKassa-Common-AbstractObject.md#method___get) |  | Возвращает значение свойства |
| public | [__isset()](../classes/YooKassa-Common-AbstractObject.md#method___isset) |  | Проверяет наличие свойства |
| public | [__set()](../classes/YooKassa-Common-AbstractObject.md#method___set) |  | Устанавливает значение свойства |
| public | [__unset()](../classes/YooKassa-Common-AbstractObject.md#method___unset) |  | Удаляет свойство |
| public | [fromArray()](../classes/YooKassa-Common-AbstractObject.md#method_fromArray) |  | Устанавливает значения свойств текущего объекта из массива |
| public | [getConfirmation()](../classes/YooKassa-Model-SelfEmployed-SelfEmployed.md#method_getConfirmation) |  | Возвращает сценарий подтверждения. |
| public | [getCreatedAt()](../classes/YooKassa-Model-SelfEmployed-SelfEmployed.md#method_getCreatedAt) |  | Возвращает время создания объекта самозанятого |
| public | [getId()](../classes/YooKassa-Model-SelfEmployed-SelfEmployed.md#method_getId) |  | Возвращает id. |
| public | [getItn()](../classes/YooKassa-Model-SelfEmployed-SelfEmployed.md#method_getItn) |  | Возвращает ИНН самозанятого |
| public | [getPhone()](../classes/YooKassa-Model-SelfEmployed-SelfEmployed.md#method_getPhone) |  | Возвращает телефон самозанятого. |
| public | [getStatus()](../classes/YooKassa-Model-SelfEmployed-SelfEmployed.md#method_getStatus) |  | Возвращает статус самозанятого. |
| public | [getTest()](../classes/YooKassa-Model-SelfEmployed-SelfEmployed.md#method_getTest) |  | Возвращает признак тестовой операции. |
| public | [jsonSerialize()](../classes/YooKassa-Common-AbstractObject.md#method_jsonSerialize) |  | Возвращает ассоциативный массив со свойствами текущего объекта для его дальнейшей JSON сериализации |
| public | [offsetExists()](../classes/YooKassa-Common-AbstractObject.md#method_offsetExists) |  | Проверяет наличие свойства |
| public | [offsetGet()](../classes/YooKassa-Common-AbstractObject.md#method_offsetGet) |  | Возвращает значение свойства |
| public | [offsetSet()](../classes/YooKassa-Common-AbstractObject.md#method_offsetSet) |  | Устанавливает значение свойства |
| public | [offsetUnset()](../classes/YooKassa-Common-AbstractObject.md#method_offsetUnset) |  | Удаляет свойство |
| public | [setConfirmation()](../classes/YooKassa-Model-SelfEmployed-SelfEmployed.md#method_setConfirmation) |  | Устанавливает сценарий подтверждения. |
| public | [setCreatedAt()](../classes/YooKassa-Model-SelfEmployed-SelfEmployed.md#method_setCreatedAt) |  | Устанавливает время создания объекта самозанятого |
| public | [setId()](../classes/YooKassa-Model-SelfEmployed-SelfEmployed.md#method_setId) |  | Устанавливает идентификатор самозанятого. |
| public | [setItn()](../classes/YooKassa-Model-SelfEmployed-SelfEmployed.md#method_setItn) |  | Устанавливает ИНН самозанятого |
| public | [setPhone()](../classes/YooKassa-Model-SelfEmployed-SelfEmployed.md#method_setPhone) |  | Устанавливает телефон самозанятого. |
| public | [setStatus()](../classes/YooKassa-Model-SelfEmployed-SelfEmployed.md#method_setStatus) |  | Устанавливает статус самозанятого. |
| public | [setTest()](../classes/YooKassa-Model-SelfEmployed-SelfEmployed.md#method_setTest) |  | Устанавливает признак тестовой операции. |
| public | [toArray()](../classes/YooKassa-Common-AbstractObject.md#method_toArray) |  | Возвращает ассоциативный массив со свойствами текущего объекта для его дальнейшей JSON сериализации Является алиасом метода AbstractObject::jsonSerialize() |
| protected | [getUnknownProperties()](../classes/YooKassa-Common-AbstractObject.md#method_getUnknownProperties) |  | Возвращает массив свойств которые не существуют, но были заданы у объекта |

---
### Details
* File: [lib/Request/SelfEmployed/SelfEmployedResponse.php](../../lib/Request/SelfEmployed/SelfEmployedResponse.php)
* Package: YooKassa\Model
* Class Hierarchy:  
  * [\YooKassa\Common\AbstractObject](../classes/YooKassa-Common-AbstractObject.md)
  * [\YooKassa\Model\SelfEmployed\SelfEmployed](../classes/YooKassa-Model-SelfEmployed-SelfEmployed.md)
  * \YooKassa\Request\SelfEmployed\SelfEmployedResponse

---
### Tags
| Tag | Version | Description |
| --- | ------- | ----------- |
| author |  | cms@yoomoney.ru |

---
## Properties
<a name="property_confirmation"></a>
#### public $confirmation : \YooKassa\Model\SelfEmployed\SelfEmployedConfirmation|null
---
***Description***

Сценарий подтверждения пользователем заявки ЮMoney на получение прав для регистрации чеков в сервисе Мой налог.

**Type:** <a href="../\YooKassa\Model\SelfEmployed\SelfEmployedConfirmation|null"><abbr title="\YooKassa\Model\SelfEmployed\SelfEmployedConfirmation|null">SelfEmployedConfirmation|null</abbr></a>

**Details:**
* Inherited From: [\YooKassa\Model\SelfEmployed\SelfEmployed](../classes/YooKassa-Model-SelfEmployed-SelfEmployed.md)


<a name="property_created_at"></a>
#### public $created_at : \DateTime
---
***Description***

Время создания объекта самозанятого.

**Type:** \DateTime

**Details:**
* Inherited From: [\YooKassa\Model\SelfEmployed\SelfEmployed](../classes/YooKassa-Model-SelfEmployed-SelfEmployed.md)


<a name="property_createdAt"></a>
#### public $createdAt : \DateTime
---
***Description***

Время создания объекта самозанятого.

**Type:** \DateTime

**Details:**
* Inherited From: [\YooKassa\Model\SelfEmployed\SelfEmployed](../classes/YooKassa-Model-SelfEmployed-SelfEmployed.md)


<a name="property_id"></a>
#### public $id : string
---
***Description***

Идентификатор самозанятого в ЮKassa.

**Type:** <a href="../string"><abbr title="string">string</abbr></a>

**Details:**
* Inherited From: [\YooKassa\Model\SelfEmployed\SelfEmployed](../classes/YooKassa-Model-SelfEmployed-SelfEmployed.md)


<a name="property_itn"></a>
#### public $itn : string|null
---
***Description***

ИНН самозанятого.

**Type:** <a href="../string|null"><abbr title="string|null">string|null</abbr></a>

**Details:**
* Inherited From: [\YooKassa\Model\SelfEmployed\SelfEmployed](../classes/YooKassa-Model-SelfEmployed-SelfEmployed.md)


<a name="property_phone"></a>
#### public $phone : string|null
---
***Description***

Телефон самозанятого, который привязан к личному кабинету в сервисе Мой налог.

**Type:** <a href="../string|null"><abbr title="string|null">string|null</abbr></a>

**Details:**
* Inherited From: [\YooKassa\Model\SelfEmployed\SelfEmployed](../classes/YooKassa-Model-SelfEmployed-SelfEmployed.md)


<a name="property_status"></a>
#### public $status : string
---
***Description***

Статус подключения самозанятого и выдачи ЮMoney прав на регистрацию чеков.

**Type:** <a href="../string"><abbr title="string">string</abbr></a>

**Details:**
* Inherited From: [\YooKassa\Model\SelfEmployed\SelfEmployed](../classes/YooKassa-Model-SelfEmployed-SelfEmployed.md)


<a name="property_test"></a>
#### public $test : bool
---
***Description***

Признак тестовой операции.

**Type:** <a href="../bool"><abbr title="bool">bool</abbr></a>

**Details:**
* Inherited From: [\YooKassa\Model\SelfEmployed\SelfEmployed](../classes/YooKassa-Model-SelfEmployed-SelfEmployed.md)



---
## Methods
<a name="method___construct" class="anchor"></a>
#### public __construct() : mixed

```php
public __construct(array $data = array()) : mixed
```

**Summary**

AbstractObject constructor.

**Details:**
* Inherited From: [\YooKassa\Common\AbstractObject](../classes/YooKassa-Common-AbstractObject.md)

##### Parameters:
| Type | Name | Description |
| ---- | ---- | ----------- |
| <code lang="php">array</code> | data  |  |

**Returns:** mixed - 


<a name="method___get" class="anchor"></a>
#### public __get() : mixed

```php
public __get(string $propertyName) : mixed
```

**Summary**

Возвращает значение свойства

**Details:**
* Inherited From: [\YooKassa\Common\AbstractObject](../classes/YooKassa-Common-AbstractObject.md)

##### Parameters:
| Type | Name | Description |
| ---- | ---- | ----------- |
| <code lang="php">string</code> | propertyName  | Имя свойства |

**Returns:** mixed - Значение свойства


<a name="method___isset" class="anchor"></a>
#### public __isset() : bool

```php
public __isset(string $propertyName) : bool
```

**Summary**

Проверяет наличие свойства

**Details:**
* Inherited From: [\YooKassa\Common\AbstractObject](../classes/YooKassa-Common-AbstractObject.md)

##### Parameters:
| Type | Name | Description |
| ---- | ---- | ----------- |
| <code lang="php">string</code> | propertyName  | Имя проверяемого свойства |

**Returns:** bool - True если свойство имеется, false если нет


<a name="method___set" class="anchor"></a>
#### public __set() : mixed

```php
public __set(string $propertyName, mixed $value) : mixed
```

**Summary**

Устанавливает значение свойства

**Details:**
* Inherited From: [\YooKassa\Common\AbstractObject](../classes/YooKassa-Common-AbstractObject.md)

##### Parameters:
| Type | Name | Description |
| ---- | ---- | ----------- |
| <code lang="php">string</code> | propertyName  | Имя свойства |
| <code lang="php">mixed</code> | value  | Значение свойства |

**Returns:** mixed - 


<a name="method___unset" class="anchor"></a>
#### public __unset() : mixed

```php
public __unset(string $propertyName) : mixed
```

**Summary**

Удаляет свойство

**Details:**
* Inherited From: [\YooKassa\Common\AbstractObject](../classes/YooKassa-Common-AbstractObject.md)

##### Parameters:
| Type | Name | Description |
| ---- | ---- | ----------- |
| <code lang="php">string</code> | propertyName  | Имя удаляемого свойства |

**Returns:** mixed - 


<a name="method_fromArray" class="anchor"></a>
#### public fromArray() : mixed

```php
public fromArray(array|\Traversable $sourceArray) : mixed
```

**Summary**

Устанавливает значения свойств текущего объекта из массива

**Details:**
* Inherited From: [\YooKassa\Common\AbstractObject](../classes/YooKassa-Common-AbstractObject.md)

##### Parameters:
| Type | Name | Description |
| ---- | ---- | ----------- |
| <code lang="php">array OR \Traversable</code> | sourceArray  | Ассоциативный массив с настройками |

**Returns:** mixed - 


<a name="method_getConfirmation" class="anchor"></a>
#### public getConfirmation() : \YooKassa\Model\SelfEmployed\SelfEmployedConfirmation|null

```php
public getConfirmation() : \YooKassa\Model\SelfEmployed\SelfEmployedConfirmation|null
```

**Summary**

Возвращает сценарий подтверждения.

**Details:**
* Inherited From: [\YooKassa\Model\SelfEmployed\SelfEmployed](../classes/YooKassa-Model-SelfEmployed-SelfEmployed.md)

**Returns:** \YooKassa\Model\SelfEmployed\SelfEmployedConfirmation|null - Сценарий подтверждения


<a name="method_getCreatedAt" class="anchor"></a>
#### public getCreatedAt() : \DateTime

```php
public getCreatedAt() : \DateTime
```

**Summary**

Возвращает время создания объекта самозанятого

**Details:**
* Inherited From: [\YooKassa\Model\SelfEmployed\SelfEmployed](../classes/YooKassa-Model-SelfEmployed-SelfEmployed.md)

**Returns:** \DateTime - Время создания объекта самозанятого


<a name="method_getId" class="anchor"></a>
#### public getId() : string

```php
public getId() : string
```

**Summary**

Возвращает id.

**Details:**
* Inherited From: [\YooKassa\Model\SelfEmployed\SelfEmployed](../classes/YooKassa-Model-SelfEmployed-SelfEmployed.md)

**Returns:** string - 


<a name="method_getItn" class="anchor"></a>
#### public getItn() : string|null

```php
public getItn() : string|null
```

**Summary**

Возвращает ИНН самозанятого

**Details:**
* Inherited From: [\YooKassa\Model\SelfEmployed\SelfEmployed](../classes/YooKassa-Model-SelfEmployed-SelfEmployed.md)

**Returns:** string|null - ИНН самозанятого


<a name="method_getPhone" class="anchor"></a>
#### public getPhone() : string|null

```php
public getPhone() : string|null
```

**Summary**

Возвращает телефон самозанятого.

**Details:**
* Inherited From: [\YooKassa\Model\SelfEmployed\SelfEmployed](../classes/YooKassa-Model-SelfEmployed-SelfEmployed.md)

**Returns:** string|null - Телефон самозанятого


<a name="method_getStatus" class="anchor"></a>
#### public getStatus() : string

```php
public getStatus() : string
```

**Summary**

Возвращает статус самозанятого.

**Details:**
* Inherited From: [\YooKassa\Model\SelfEmployed\SelfEmployed](../classes/YooKassa-Model-SelfEmployed-SelfEmployed.md)

**Returns:** string - Статус самозанятого


<a name="method_getTest" class="anchor"></a>
#### public getTest() : bool

```php
public getTest() : bool
```

**Summary**

Возвращает признак тестовой операции.

**Details:**
* Inherited From: [\YooKassa\Model\SelfEmployed\SelfEmployed](../classes/YooKassa-Model-SelfEmployed-SelfEmployed.md)

**Returns:** bool - Признак тестовой операции.


<a name="method_jsonSerialize" class="anchor"></a>
#### public jsonSerialize() : array

```php
public jsonSerialize() : array
```

**Summary**

Возвращает ассоциативный массив со свойствами текущего объекта для его дальнейшей JSON сериализации

**Details:**
* Inherited From: [\YooKassa\Common\AbstractObject](../classes/YooKassa-Common-AbstractObject.md)

**Returns:** array - Ассоциативный массив со свойствами текущего объекта


<a name="method_offsetExists" class="anchor"></a>
#### public offsetExists() : bool

```php
public offsetExists(string $offset) : bool
```

**Summary**

Проверяет наличие свойства

**Details:**
* Inherited From: [\YooKassa\Common\AbstractObject](../classes/YooKassa-Common-AbstractObject.md)

##### Parameters:
| Type | Name | Description |
| ---- | ---- | ----------- |
| <code lang="php">string</code> | offset  | Имя проверяемого свойства |

**Returns:** bool - True если свойство имеется, false если нет


<a name="method_offsetGet" class="anchor"></a>
#### public offsetGet() : mixed

```php
public offsetGet(string $offset) : mixed
```

**Summary**

Возвращает значение свойства

**Details:**
* Inherited From: [\YooKassa\Common\AbstractObject](../classes/YooKassa-Common-AbstractObject.md)

##### Parameters:
| Type | Name | Description |
| ---- | ---- | ----------- |
| <code lang="php">string</code> | offset  | Имя свойства |

**Returns:** mixed - Значение свойства


<a name="method_offsetSet" class="anchor"></a>
#### public offsetSet() : void

```php
public offsetSet(string $offset, mixed $value) : void
```

**Summary**

Устанавливает значение свойства

**Details:**
* Inherited From: [\YooKassa\Common\AbstractObject](../classes/YooKassa-Common-AbstractObject.md)

##### Parameters:
| Type | Name | Description |
| ---- | ---- | ----------- |
| <code lang="php">string</code> | offset  | Имя свойства |
| <code lang="php">mixed</code> | value  | Значение свойства |

**Returns:** void - 


<a name="method_offsetUnset" class="anchor"></a>
#### public offsetUnset() : void

```php
public offsetUnset(string $offset) : void
```

**Summary**

Удаляет свойство

**Details:**
* Inherited From: [\YooKassa\Common\AbstractObject](../classes/YooKassa-Common-AbstractObject.md)

##### Parameters:
| Type | Name | Description |
| ---- | ---- | ----------- |
| <code lang="php">string</code> | offset  | Имя удаляемого свойства |

**Returns:** void - 


<a name="method_setConfirmation" class="anchor"></a>
#### public setConfirmation() : $this

```php
public setConfirmation(\YooKassa\Model\SelfEmployed\SelfEmployedConfirmation|array|null $confirmation = null) : $this
```

**Summary**

Устанавливает сценарий подтверждения.

**Details:**
* Inherited From: [\YooKassa\Model\SelfEmployed\SelfEmployed](../classes/YooKassa-Model-SelfEmployed-SelfEmployed.md)

##### Parameters:
| Type | Name | Description |
| ---- | ---- | ----------- |
| <code lang="php">\YooKassa\Model\SelfEmployed\SelfEmployedConfirmation OR array OR null</code> | confirmation  | Сценарий подтверждения |

**Returns:** $this - 


<a name="method_setCreatedAt" class="anchor"></a>
#### public setCreatedAt() : $this

```php
public setCreatedAt(\DateTime|string|int $created_at) : $this
```

**Summary**

Устанавливает время создания объекта самозанятого

**Details:**
* Inherited From: [\YooKassa\Model\SelfEmployed\SelfEmployed](../classes/YooKassa-Model-SelfEmployed-SelfEmployed.md)

##### Parameters:
| Type | Name | Description |
| ---- | ---- | ----------- |
| <code lang="php">\DateTime OR string OR int</code> | created_at  | Время создания объекта самозанятого |

##### Throws:
| Type | Description |
| ---- | ----------- |
| \YooKassa\Common\Exceptions\EmptyPropertyValueException | Выбрасывается если в метод была передана пустая дата |
| \YooKassa\Common\Exceptions\InvalidPropertyValueException | Выбрасывается если передали строку, которую не удалось привести к дате |
| \YooKassa\Common\Exceptions\InvalidPropertyValueTypeException|\Exception | Выбрасывается если был передан аргумент, который невозможно интерпретировать как дату или время |

**Returns:** $this - 


<a name="method_setId" class="anchor"></a>
#### public setId() : $this

```php
public setId(string $id) : $this
```

**Summary**

Устанавливает идентификатор самозанятого.

**Details:**
* Inherited From: [\YooKassa\Model\SelfEmployed\SelfEmployed](../classes/YooKassa-Model-SelfEmployed-SelfEmployed.md)

##### Parameters:
| Type | Name | Description |
| ---- | ---- | ----------- |
| <code lang="php">string</code> | id  | Идентификатор самозанятого в ЮKassa. |

**Returns:** $this - 


<a name="method_setItn" class="anchor"></a>
#### public setItn() : $this

```php
public setItn(string|null $itn = null) : $this
```

**Summary**

Устанавливает ИНН самозанятого

**Details:**
* Inherited From: [\YooKassa\Model\SelfEmployed\SelfEmployed](../classes/YooKassa-Model-SelfEmployed-SelfEmployed.md)

##### Parameters:
| Type | Name | Description |
| ---- | ---- | ----------- |
| <code lang="php">string OR null</code> | itn  | ИНН самозанятого |

**Returns:** $this - 


<a name="method_setPhone" class="anchor"></a>
#### public setPhone() : $this

```php
public setPhone(string|null $phone = null) : $this
```

**Summary**

Устанавливает телефон самозанятого.

**Details:**
* Inherited From: [\YooKassa\Model\SelfEmployed\SelfEmployed](../classes/YooKassa-Model-SelfEmployed-SelfEmployed.md)

##### Parameters:
| Type | Name | Description |
| ---- | ---- | ----------- |
| <code lang="php">string OR null</code> | phone  | Телефон самозанятого |

**Returns:** $this - 


<a name="method_setStatus" class="anchor"></a>
#### public setStatus() : $this

```php
public setStatus(string $status) : $this
```

**Summary**

Устанавливает статус самозанятого.

**Details:**
* Inherited From: [\YooKassa\Model\SelfEmployed\SelfEmployed](../classes/YooKassa-Model-SelfEmployed-SelfEmployed.md)

##### Parameters:
| Type | Name | Description |
| ---- | ---- | ----------- |
| <code lang="php">string</code> | status  | Статус самозанятого |

**Returns:** $this - 


<a name="method_setTest" class="anchor"></a>
#### public setTest() : $this

```php
public setTest(bool $test) : $this
```

**Summary**

Устанавливает признак тестовой операции.

**Details:**
* Inherited From: [\YooKassa\Model\SelfEmployed\SelfEmployed](../classes/YooKassa-Model-SelfEmployed-SelfEmployed.md)

##### Parameters:
| Type | Name | Description |
| ---- | ---- | ----------- |
| <code lang="php">bool</code> | test  | Признак тестовой операции. |

**Returns:** $this - 


<a name="method_toArray" class="anchor"></a>
#### public toArray() : array

```php
public toArray() : array
```

**Summary**

Возвращает ассоциативный массив со свойствами текущего объекта для его дальнейшей JSON сериализации
Является алиасом метода AbstractObject::jsonSerialize()

**Details:**
* Inherited From: [\YooKassa\Common\AbstractObject](../classes/YooKassa-Common-AbstractObject.md)

**Returns:** array - Ассоциативный массив со свойствами текущего объекта


<a name="method_getUnknownProperties" class="anchor"></a>
#### protected getUnknownProperties() : array

```php
protected getUnknownProperties() : array
```

**Summary**

Возвращает массив свойств которые не существуют, но были заданы у объекта

**Details:**
* Inherited From: [\YooKassa\Common\AbstractObject](../classes/YooKassa-Common-AbstractObject.md)

**Returns:** array - Ассоциативный массив с не существующими у текущего объекта свойствами



---

### Top Namespaces

* [\YooKassa](../namespaces/yookassa.md)

---

### Reports
* [Errors - 0](../reports/errors.md)
* [Markers - 1](../reports/markers.md)
* [Deprecated - 35](../reports/deprecated.md)

---

This document was automatically generated from source code comments on 2023-08-02 using [phpDocumentor](http://www.phpdoc.org/)

&copy; 2023 YooMoney